// normally the model is passed to the view instead of the view creating the model
define([
    'marionette',
    'App',
    'modules/appointments/appointments-module',

    'modules/form/section-view',
    'text!modules/new-appointment-request/views/requests/express-care/template.html',
    'json!modules/new-appointment-request/views/requests/express-care/section.json',
],
function(
    Marionette,
    app,
    module,

    SectionView,
    template,
    metadata
) {
    'use strict';

    return SectionView.extend({
        template: template,
        collectionEvents: {'change:value': 'updateFDNS   el'},
        modelEvents: {'change:reasonForVisit': 'showHideOtherReasonQuestionAndValidation'},
        initialize: function(options) {
            var sectionName = 'express-care-details-reason-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
            this.validator = options.validator;
            this.setReasonQuestionModel(options.reasons);
        },
        onRender: function() {
            this.initChildren();
            this.showHideOtherReasonQuestionAndValidation();
        },
        setReasonQuestionModel: function(reasons) {
            var reasonForVisitQuestion = this.collection.get('reasonForVisit');
            var reasonOptions = [];
            reasons.each(function(reason) {
                reasonOptions.push({
                    id: reason.get('id'),
                    text: reason.get('name'),
                    value: reason.get('id'),
                });
            }, this);
            reasonForVisitQuestion.set('values', reasonOptions);
        },
        showHideOtherReasonQuestionAndValidation: function() {
            // id 13 is option "Other"
            this.showHideQuestionAndValidation('.other-question',
                !(this.model.has('reasonForVisit') && this.model.get('reasonForVisit') === 'ZZ'));
        },
        showHideQuestionAndValidation: function(selector, isHidden) {
            var $question;

            if (!this.isDestroyed()) {
                $question = this.$el.find(selector);

                $question.toggleClass('hidden', isHidden);

                if (isHidden) {
                    this.hideValidationErrorsFor($question);
                }
            }
        },
    });
});
